// create a new spawnmenu class
local CSpawnMenu	= OOP_Derive( CHook, CTimer, CCommand, CVMFSettings );

// constructor
function CSpawnMenu:__ctor( )
	// hook events
	self:HookEvent( "PlayerInitialSpawn" );
	
	// hook commands
	self:HookCommand( "VMF_RequestList" );

	// timer frequency.
	self:SetFrequency( 0.1 );
	
	// the list of menu entries to send and to where.
	self.SendBuffer = {};
	
end

// VMF List request.
function CSpawnMenu:OnVMF_RequestList( pl, args )
	// read id.
	local id = tonumber( args[1] );
	
	// setup path
	local path = table.concat( args, " ", 2 );
	
	// debug
	if( VMFSuite.Debug ) then
		print( "ID - " .. id .. ", Path - " .. path );
		
	end
	
	// dispatch
	self:Dispatch( pl, id, path );

end

// Dispatch
function CSpawnMenu:Dispatch( pl, id, path )
	// replace all back slashes with forward slashes
	// and default to vmf/server if no path is given.
	path = string.gsub( path or "vmf/server", "\\", "/" );
	
	// add the trailing slash if it doesn't exist.
	if( string.sub( path, string.len( path ), string.len( path ) ) != "/" ) then
		path = path .. "/";
		
	end
	
	// Get all vmfs in the desired path.
	local list, i = file.Find( "../" .. path .. "*.*" );
	for i = 1, table.getn( list ) do
		// append path.
		local filename = path .. list[i];
		
		// add to the send buffer.
		local entry = {
			id = id or -1,
			more = i < table.getn( list ),
			flag = self:GetFlag( filename ),
			filename = filename,
			pl = pl,
		};
		table.insert( self.SendBuffer, entry );
		
	end
	
end

// timer event.
function CSpawnMenu:OnTimer( )
	// lets dispatch a menu entry.
	if( table.getn( self.SendBuffer ) > 0 ) then
		// fetch the first element.
		local entry = self.SendBuffer[1];
		
		// remove it
		table.remove( self.SendBuffer, 1 );
		
		// send it.
		umsg.Start( "VMFList", entry.pl );
			umsg.Short( entry.id );
			umsg.Bool( entry.more );
			umsg.Short( entry.flag );
			umsg.String( entry.filename );
		umsg.End();
	
	end
	
end

// Set panel
function CSpawnMenu:SetPanel( pl, index )
	// send the spawnmenu set panel index.
	umsg.Start( "PanelIndex", pl );
		umsg.Short( index );
	umsg.End();
	
end

// Player spawned
function CSpawnMenu:OnPlayerInitialSpawn( pl )
	// send the toplevel menu.
	self:Dispatch( pl );

end

// create
VMFSuite.SpawnMenu = CSpawnMenu:create();
